% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableLargeScaleCharacteristics.R
\name{tableTopLargeScaleCharacteristics}
\alias{tableTopLargeScaleCharacteristics}
\title{Visualise the top concepts per each cdm name, cohort, statification and
window.}
\usage{
tableTopLargeScaleCharacteristics(
  result,
  topConcepts = 10,
  type = NULL,
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{topConcepts}{Number of concepts to restrict the table.}

\item{type}{Type of table, it can be any of the supported
\code{visOmopResults::tableType()} formats.}

\item{style}{Defines the visual formatting of the table. This argument can
be provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style}: Use the name of a built-in style (e.g., "darwin").
See \code{visOmopResults::tableStyle()} for available options.
\item \strong{YAML file path}: Provide the path to an existing .yml file defining a
new style.
\item \strong{List of custome R code}: Supply a block of custom R code or a named
list describing styles for each table section. This code must be specific to
the selected table type.
}

If style = \code{NULL}, the function will use global
options (see \code{visOmopResults::setGlobalTableOptions()}) or an existing
\verb{_brand.yml} file (if found); otherwise, the default style is applied. For
more details, see the \emph{Styles} vignette in \strong{visOmopResults} website.}
}
\value{
A formated table.
}
\description{
Visualise the top concepts per each cdm name, cohort, statification and
window.
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
libarry(CDMConnector)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateConceptCohortSet(
  cdm = cdm,
  conceptSet = list(viral_pharyngitis = 4112343),
  name = "my_cohort"
)

result <- summariseLargeScaleCharacteristics(
  cohort = cdm$my_cohort,
  window = list(c(-Inf, -1), c(0, 0), c(1, Inf)),
  episodeInWindow = "drug_exposure"
)

tableTopLargeScaleCharacteristics(result)

cdmDisconnect(cdm)
}

}
