% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_plot_functions.R
\name{plot_evaluation.list}
\alias{plot_evaluation.list}
\title{plot_evaluation.list}
\usage{
plot_evaluation.list(
  lst_eval_results,
  evaluation = "AUC",
  pred.attr = "mean",
  y.min = NULL,
  type = "both",
  round_times = FALSE,
  decimals = 2,
  title = NULL,
  title_size_text = 15,
  subtitle = NULL,
  subtitle_size_text = 12,
  legend.position = "right",
  legend_title = "Method",
  legend_size_text = 12,
  x_axis_size_text = 10,
  y_axis_size_text = 10,
  label_x_axis_size = 10,
  label_y_axis_size = 10,
  txt.x.angle = 0
)
}
\arguments{
\item{lst_eval_results}{List (named) of Coxmos evaluation results from \code{eval_Coxmos_models()}.}

\item{evaluation}{Character. Perform the evaluation using the "AUC" or "IBS" metric (default: "AUC").}

\item{pred.attr}{Character. Way to evaluate the metric selected. Must be one of the following:
"mean" or "median" (default: "mean").}

\item{y.min}{Numeric. Minimum Y value for establish the Y axis value. If y.min = NULL, automatic
detection is performed (default: NULL).}

\item{type}{Character. Plot type. Must be one of the following: "both", "line" or "mean". In other
case, "both" will be selected (default: "both").}

\item{round_times}{Logical. Whether times x value should be rounded (default: FALSE).}

\item{decimals}{Numeric. Number of decimals to use in round times. Must be a value greater or
equal zero (default = 2).}

\item{title}{Character. Plot title (default: NULL).}

\item{title_size_text}{Numeric. Text size for title (default: 15).}

\item{subtitle}{Character. Plot subtitle (default: NULL).}

\item{subtitle_size_text}{Numeric. Text size for subtitle (default: 12).}

\item{legend.position}{Character. Legend position. Must be one of the following: "top", "bottom", "right" or "left (default: "right").}

\item{legend_title}{Character. Legend title (default: "Method").}

\item{legend_size_text}{Numeric. Text size for legend title (default: 12).}

\item{x_axis_size_text}{Numeric. Text size for x axis (default: 10).}

\item{y_axis_size_text}{Numeric. Text size for y axis (default: 10).}

\item{label_x_axis_size}{Numeric. Text size for x label axis (default: 10).}

\item{label_y_axis_size}{Numeric. Text size for y label axis (default: 10).}

\item{txt.x.angle}{Numeric. Angle of X text (default: 0).}
}
\value{
A list of lst_eval_results length. Each element is a list of three elements.
\code{lst_plots}: A list of two plots. The evaluation over the time, and the extension adding the
mean or median on the right.
\code{lst_plot_comparisons}: A list of comparative boxplots by t.test, anova, wilcoxon, kruscal.
\code{df}: Data.frame of evaluation result.
}
\description{
Run the function "plot_evaluation" for a list of results. More information in
"?plot_evaluation".
}
\examples{
data("X_proteomic")
data("Y_proteomic")
set.seed(123)
index_train <- caret::createDataPartition(Y_proteomic$event, p = .5, list = FALSE, times = 1)
X_train <- X_proteomic[index_train,1:50]
Y_train <- Y_proteomic[index_train,]
X_test <- X_proteomic[-index_train,1:50]
Y_test <- Y_proteomic[-index_train,]
coxEN.model <- coxEN(X_train, Y_train, x.center = TRUE, x.scale = TRUE)
eval_results <- list()
eval_results[["cenROC"]] <- eval_Coxmos_models(lst_models = list("coxEN" = coxEN.model),
X_test = X_test, Y_test = Y_test, pred.method = "cenROC")
eval_results[["survivalROC"]] <- eval_Coxmos_models(lst_models = list("coxEN" = coxEN.model),
X_test = X_test, Y_test = Y_test, pred.method = "survivalROC")
plot_eval_results <- plot_evaluation.list(eval_results)
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
