test_that("any_polyphyly works correctly for no polyphyly", {
  phylod <- create_test_phylod(test_scenario = 1)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 2)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 3)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 4)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 5)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 6)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 7)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 8)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 9)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 10)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 11)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 12)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 13)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 14)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 15)
  expect_false(any_polyphyly(phylod = phylod))
  phylod <- create_test_phylod(test_scenario = 16)
  expect_false(any_polyphyly(phylod = phylod))
})

test_that("any_polyphyly works correctly for non-polyphyletic species", {
  set.seed(1)
  phylo <- ape::rcoal(3)
  phylo$tip.label <- c("bird_a_1", "bird_a_2", "bird_b")
  phylo <- phylobase::phylo4(phylo)
  endemicity_status <- c("endemic", "endemic", "not_present")
  phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
  expect_false(any_polyphyly(phylod = phylod))
})

test_that("any_polyphyly works correctly for polyphyletic species", {
  set.seed(1)
  phylo <- ape::rcoal(3)
  phylo$tip.label <- c("bird_a_1", "bird_b", "bird_a_2")
  phylo <- phylobase::phylo4(phylo)
  endemicity_status <- c("endemic", "endemic", "not_present")
  phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
  expect_true(any_polyphyly(phylod = phylod))
})

test_that("any_polyphyly works correctly for multiple polyphyletic species", {
  set.seed(1)
  phylo <- ape::rcoal(6)
  phylo$tip.label <- c(
    "bird_a_1", "bird_b_1", "bird_a_2", "bird_b_2", "bird_c", "bird_d"
  )
  phylo <- phylobase::phylo4(phylo)
  endemicity_status <- c(
    "endemic", "endemic", "endemic", "endemic", "not_present", "not_present"
  )
  phylod <- phylobase::phylo4d(phylo, as.data.frame(endemicity_status))
  expect_true(any_polyphyly(phylod = phylod))
})
