% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_followup.R
\docType{data}
\name{end_followup}
\alias{end_followup}
\title{DIVINE's table on closure data}
\format{
A data frame with 5813 rows and 8 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and  \verb{Hospital E}. Center of admission}
\item{clinical_stability_days:}{Days from hospital admission to clinical stability}
\item{exitus:}{A factor with levels \code{No} and \code{Yes}. Did the patient die during hospital admission?}
\item{exitus_days:}{Days from hospital admission to exitus}
\item{discharge:}{A factor with levels \code{No} and \code{Yes}. Was the patient discharge from the hospital?}
\item{discharge_days:}{Days from hospital admission to discharge}
}
}
\usage{
data(end_followup)
}
\description{
Information on closure data of patients included in the DIVINE cohort. Data was collected at the end of hospitalization.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
