% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiSCo_weights_reg.R
\name{DiSCo_weights_reg}
\alias{DiSCo_weights_reg}
\title{DiSCo_weights_reg}
\usage{
DiSCo_weights_reg(
  controls,
  target,
  M = 500,
  qmethod = NULL,
  qtype = 7,
  simplex = FALSE,
  q_min = 0,
  q_max = 1
)
}
\arguments{
\item{controls}{List with matrices of control distributions}

\item{target}{Matrix containing the target distribution}

\item{M}{Integer indicating the number of control quantiles to use in the DiSCo method. Default is 1000.}

\item{qmethod}{Character, indicating the method to use for computing the quantiles of the target distribution. The default is NULL, which uses the \code{\link[stats]{quantile}} function from the stats package.
Other options are "\code{\link[evmix]{qkden}}" (based on smoothed kernel density function) and "\code{\link[extremeStat:distLquantile]{extreme}}" (based on parametric extreme value distributions).
Both are substantially slower than the default method but may be useful for fat-tailed distributions with few data points at the upper quantiles. Alternatively, one could use the q_max option to restrict the range of quantiles used.}

\item{qtype}{Integer, indicating the type of quantile to compute when using  \code{\link[stats]{quantile}} in the \code{qmethod} argument.
The default 7. See the documentation for the \code{\link[stats]{quantile}} function for more information.}

\item{simplex}{Logical, indicating whether to use to constrain the optimal weights to the unit simplex. Default is FALSE, which only constrains the weights to sum up to 1 but allows them to be negative.}

\item{q_min}{Numeric, minimum quantile to use. Set this together with \code{q_max} to restrict the range of quantiles used to construct the synthetic control.
Default is 0 (all quantiles). Currently NOT implemented for the \code{mixture} approach.}

\item{q_max}{Numeric, maximum quantile to use. Set this together with \code{q_min} to restrict the range of quantiles used to construct the synthetic control.
Default is 1 (all quantiles). Currently NOT implemented for the \code{mixture} approach.}
}
\value{
Vector of optimal synthetic control weights
}
\description{
Function for obtaining the weights in the DiSCo method at every time period
}
\details{
Estimate the optimal weights for the distributional synthetic controls method.
solving the convex minimization problem in Eq. (2) in \insertCite{gunsilius2023distributional;textual}{DiSCos}..
using a regression of the simulated target quantile on the simulated control quantiles, as in Eq. (3),
\eqn{\underset{\vec{\lambda} \in \Delta^J}{\operatorname{argmin}}\left\|\mathbb{Y}_t \vec{\lambda}_t-\vec{Y}_{1 t}\right\|_2^2}.
For the constrained optimization we rely on the package pracma
the control distributions can be given in list form, where each list element contains a
vector of observations for the given control unit, in matrix form;
in matrix- each column corresponds to one unit and each row is one observation.
The list-form is useful, because the number of draws for each control group can be different.
The target must be given as a vector.
}
\references{
\insertAllCited{}
}
\keyword{internal}
