% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_names.R
\name{read_data_entity_names}
\alias{read_data_entity_names}
\title{Read data entity names}
\usage{
read_data_entity_names(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(data.frame) Names and identifiers of all data entities in
\code{packageId}
}
\description{
Read data entity names
}
\examples{
\dontrun{

read_data_entity_names("knb-lter-cap.691.2")
#>                           entityId
#> 1 f6e4efd0b04aea3860724824ca05c5dd
#> 2 d2263480e75cc7888b41928602cda4c6
#> 3 d5cb83e4556408e48f636157e4dee49e
#>                                                 entityName
#> 1      691_arthropods_00742cd00ab0d3d02337e28d1c919654.csv
#> 2        691_captures_e5f57a98ae0b7941b10d4a600645495a.csv
#> 3 691_sampling_events_e8d76d7e76385e4ae84bcafb754d0093.csv
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
