

\name{emxModelByID}
\alias{emxModelByID}

\title{Create a model for each ID}

\description{
This function helps modeling across multiple units of analysis by either
creating a separate model for every ID in a dataset or creating a
multiple group model with each ID as a group and parameter equality
constraints across groups.  The function optionally fits the model or
models, and finally returns either a list of models for each ID or the
multigroup model.
}

\usage{
emxModelByID(model, data, name, run=FALSE, ID, equal=c("none", "labels", "all"), ...)
}


\arguments{
   \item{model}{MxModel object.  A separate model with this structure will be made and optionally fit for each ID}
   \item{data}{data used for the model.  A list of data.frame objects or a single data.frame with an ID variable}
   \item{name}{character.  Optional name of the model created.  The individual models have this name pasted together with their ID value.}
   \item{run}{logical. Whether to run the model before returning.}
   \item{ID}{character.  Name of variable that identifies each unique
     person.}
   \item{equal}{character.  Which parameters to constrain to be equal
   across ID values.  See Details.}
   \item{...}{Force later arguments to be named.  ... is ignored.}
}

\details{
The original intent of this function is to facillitate person-specific
modeling of multisubject time series data.  However, it is built with
sufficient generality to allow many other uses.  Any model you want to
fit separately by some ID variable can be split and fit with this
function.  The function also allows partial or complete parameter
equality constraints across IDs.

The model can be any model built by EasyMx or OpenMx.  Time series
models, factor models, full structural equation models, and behavior
genetics models are a few relevant possbilities.

The ID variable could be a person ID, a group ID, a family ID, a country
ID, and so on.  Thus, this function can be useful for several types of
invariance testing that start by allowing all parameters across a
grouping variable to be distinct.  Similarly, this function can be
useful as a comparison to multilevel modeling.  Instead of allowing
parameters to vary across the ID variable according to a distribution,
this function estimates all parameters separately.

The \code{equal} argument determines which parameters are constrained to be
equal across IDs.  The value \code{"none"} means that none of the parameters
are equal across IDs; each model is estimated completely independently.
In this case a list of models is returned.  The value \code{"labels"} means that labeled parameters in the original model
will be constrained to be equal, but unlabeled parameters will be
different across IDs.  Because some of the parameters might be equal
across IDs, the model is created as a single, multiple group model.  Unless
used judiciously, use of the \code{"labels"} value can lead to multiple group models with an enormous
number of free parameters.  The value \code{"all"} constrains all parameters to
be equal across groups.
}

\value{
    An MxModel object or list of MxModel objects.
}

\seealso{
\link{emxStateSpaceMixtureClassify} , \link{emxMixtureModel}
}
% \link{emxStateSpaceModel}

%\references{
%
%}

\examples{

# Example
require(EasyMx)
data(myFADataRaw)

ds0 <- myFADataRaw[,1:3]

# Make a VAR Model
vm <- emxVARModel(data=ds0, use=names(ds0), name='varmodel')

# Pretend you have a data set of 10 people
# each measured 50 times on 3 variables
ds1 <- myFADataRaw[, 1:3]
ds1$id <- rep(1:10, each=nrow(myFADataRaw)/10)

\dontrun{
# Make and fit the state space mixture model
pmod <- emxModelByID(model=vm,
    data=ds1, ID='id', run=TRUE)
sapply(pmod, coef) # person-specific model parameters
}
}
