% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_search.R
\name{fit_specified_equation}
\alias{fit_specified_equation}
\title{Fit Specified Equation}
\usage{
fit_specified_equation(
  expression,
  data,
  response = NULL,
  derivative_col = NULL,
  start = NULL,
  method = c("LM", "nls", "optim"),
  weights = NULL,
  lower = -Inf,
  upper = Inf
)
}
\arguments{
\item{expression}{Character string specifying the equation (e.g., "a + b * Z").}

\item{data}{Data frame with predictor variables.}

\item{response}{Name of the response/target column.}

\item{derivative_col}{Alias for response (for compatibility).}

\item{start}{List of starting values for parameters (auto-estimated if NULL).}

\item{method}{Optimization method: "LM" (Levenberg-Marquardt, recommended),
"nls" (standard), or "optim" (general optimization).}

\item{weights}{Optional weight vector.}

\item{lower}{Lower bounds for parameters (for "optim" method).}

\item{upper}{Upper bounds for parameters (for "optim" method).}
}
\value{
An object of class "symbolic_equation" containing the fitted model.
}
\description{
Fits a researcher-specified functional form, estimating only the
parameters. Uses Levenberg-Marquardt algorithm for robustness.
}
\examples{
\donttest{
# Toy example
data <- data.frame(Z = seq(1, 10, length.out = 20))
data$dZ <- 0.5 * data$Z * (1 - data$Z / 20) + rnorm(20, sd = 0.01)

# Fit logistic equation
eq <- fit_specified_equation(
  expression = "r * Z * (1 - Z/K)",
  data = data,
  response = "dZ",
  start = list(r = 0.5, K = 20)
)
print(eq)
}

}
