% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_generate.R
\name{gemini_generate}
\alias{gemini_generate}
\title{Generate text with Google Gemini (Generative Language API) - robust w/ retries}
\usage{
gemini_generate(
  prompt,
  model = "gemini-2.5-flash",
  api_key = Sys.getenv("GEMINI_API_KEY"),
  user_agent = NULL,
  base_url = "https://generativelanguage.googleapis.com/v1beta",
  temperature = NULL,
  top_p = NULL,
  top_k = NULL,
  max_output_tokens = NULL,
  stop_sequences = NULL,
  system_instruction = NULL,
  safety_settings = NULL,
  seed = NULL,
  timeout = 120,
  verbose = FALSE,
  max_tries = 5,
  backoff_base = 0.8,
  backoff_cap = 8,
  force_markdown = TRUE,
  compile_to = c("none", "html", "docx")
)
}
\arguments{
\item{prompt}{Character scalar. The user prompt (plain text).}

\item{model}{Character scalar. Gemini model id (e.g., "gemini-2.5-flash",
"gemini-2.5-pro"). You may also pass "models/..." and it will be normalized.}

\item{api_key}{Character scalar. API key. Defaults to env var 'GEMINI_API_KEY'.}

\item{user_agent}{Character scalar. If NULL, a dynamic value is used.}

\item{base_url}{Character scalar. API base URL.}

\item{temperature}{Optional numeric in [0, 2].}

\item{top_p}{Optional numeric in (0, 1].}

\item{top_k}{Optional integer >= 1.}

\item{max_output_tokens}{Optional integer > 0.}

\item{stop_sequences}{Optional character vector.}

\item{system_instruction}{Optional character scalar.}

\item{safety_settings}{Optional list passed as-is to the API.}

\item{seed}{Optional integer seed.}

\item{timeout}{Numeric seconds for request timeout (default 120).}

\item{verbose}{Logical; if TRUE, prints URL/retries.}

\item{max_tries}{Integer. Max attempts (default 5).}

\item{backoff_base}{Numeric. Initial backoff seconds (default 0.8).}

\item{backoff_cap}{Numeric. Max backoff seconds (default 8).}

\item{force_markdown}{Logical. If TRUE, instructs the model to answer in Markdown.}

\item{compile_to}{Character scalar. One of c("none","html","docx").}
}
\value{
If compile_to = "none": character scalar (raw text as returned by the API).
If compile_to = "html": list(markdown = <string>, html_path = <path>), and opens the HTML.
If compile_to = "docx": list(markdown = <string>, docx_path = <path>), and opens the DOCX.
}
\description{
Minimal wrapper around the Generative Language API ':generateContent' endpoint
for text prompts, with retries, exponential backoff, clearer errors, and
optional output compilation (HTML/DOCX) with auto-open.
}
