% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_PCA.R
\name{trainer_PCA}
\alias{trainer_PCA}
\title{Trainer: Name a PCA dimension (FactoMineR::PCA) with an LLM-ready prompt}
\usage{
trainer_PCA(
  pca_obj,
  dimension = 1L,
  proba = 0.05,
  introduction = NULL,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{pca_obj}{A PCA object returned by \code{FactoMineR::PCA()}.}

\item{dimension}{Integer scalar; the dimension (component) to name (default 1).}

\item{proba}{Numeric in (0,1]; significance threshold used by
\code{FactoMineR::dimdesc()} to characterize the dimension (default 0.05).}

\item{introduction}{Optional character string giving the study context.
Defaults to a generic description.}

\item{audience}{One of \code{c("beginner","applied","advanced")}.}

\item{summary_only}{Logical; if TRUE, return a compact 3-bullet executive
summary (uses \code{trainer_core_summary_only_block()}).}

\item{llm_model}{Character; model name for your generator backend
(default \code{"llama3"}).}

\item{generate}{Logical; if TRUE, calls
\code{trainer_core_generate_or_return()} and returns a list with
\code{prompt}, \code{response}, and \code{model}. If FALSE, returns the
prompt string.}
}
\value{
If \code{generate = FALSE}, a character prompt string.
  If \code{generate = TRUE}, a list with \code{prompt}, \code{response}, and \code{model}.
}
\description{
Builds an English-only, audience-tailored prompt to name and justify a
principal component (dimension) from a FactoMineR::PCA object. The function
never invents numbers: it passes verbatim excerpts from `summary(pca_obj)`
(Individuals/Variables) and `FactoMineR::dimdesc()` filtered at a given
significance threshold `proba`, and instructs how to read and name the axis.
}
\examples{
\dontrun{
# Example: decathlon (FactoMineR)
if (requireNamespace("FactoMineR", quietly = TRUE)) {
data(decathlon, package = "FactoMineR")

res_pca <- FactoMineR::PCA(decathlon,
                quanti.sup = 11:12,
                quali.sup = 13,
                graph = FALSE)

intro <- "A study was conducted on decathlon athletes.
Performances on each event were measured and summarized by PCA."
intro <- gsub("\n", " ", intro); intro <- gsub("\\\\s+", " ", intro)

prompt <- trainer_PCA(res_pca,
                dimension = 1,
                proba = 0.05,
                introduction = intro,
                audience = "applied",
                generate = FALSE)

cat(prompt)

res <- gemini_generate(prompt, compile_to = "html")
}
}
}
