% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_core.R
\name{trainer_core_llm_generate}
\alias{trainer_core_llm_generate}
\title{LLM generation helper for TraineR}
\usage{
trainer_core_llm_generate(model, prompt, engine = c("ollamar", "none"), ...)
}
\arguments{
\item{model}{Character scalar, model name (e.g., "llama3").}

\item{prompt}{Character scalar, the prompt to send.}

\item{engine}{Character scalar, backend engine. Currently "ollamar" or "none".
If "none" or if the backend is not available, returns the prompt only.}

\item{...}{Passed to the backend generator.}
}
\value{
A list with elements \code{prompt}, \code{response}, \code{model},
  and \code{engine}. If the backend isn't available, \code{response} is \code{NULL}.
}
\description{
Thin wrapper around the chosen LLM backend. By default, uses \pkg{ollamar}
if installed; otherwise returns only the prompt so the caller can still
inspect it without failing.
}
