% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_select_k.R
\name{select_k}
\alias{select_k}
\title{Perform k selection}
\usage{
select_k(
  kmeans_data,
  standardise = TRUE,
  Max.k = 15,
  v_line = NULL,
  calc_gap = FALSE,
  plot_gap = FALSE,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{kmeans_data}{Data frame containing the combined PC scores and depth
statistics to perform k-means on. Output from the 'combine_data()'
function.}

\item{standardise}{TRUE or FALSE. Whether or not to standardise the data.
Defaults to TRUE.}

\item{Max.k}{Numerical. Maximum value of k to try. Defaults to 15.}

\item{v_line}{Numerical. Option to add a vertical line to plot at a specific
value of k. Defaults to NULL.}

\item{calc_gap}{TRUE or FALSE. Whether or not to calculate the gap statistic.
Defaults to FALSE}

\item{plot_gap}{TRUE or FALSE. Whether or not to plot the gap statistic.
Defaults to FALSE.}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A 'ggplot' class object and creates a figure containing both the
within-cluster sum of squares plot (elbow) and the average silhouette width
plot for 1 to 'Max.k' clusters.
}
\description{
\code{select_k} creates the elbow plot and silhouette width plot for assistance
with selection of k
}
\details{
This function relies on random initialisation in k-means clustering.
For reproducible results, users may wish to set a random seed
prior to calling this function using \code{set.seed()}.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load kmeans_data
kmeans_data <- readRDS(file.path(filepath, "data/5_k-means/combined_stats.rds"))

# Run select_k function
selecting_k <- select_k(
  kmeans_data = kmeans_data,
  standardise = TRUE,
  Max.k = 8,
  v_line = 4,
  calc_gap = FALSE,
  plot_gap = FALSE,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
