% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algan_vta_vc22.R
\name{algan_vta_vc22}
\alias{algan_vta_vc22}
\title{Volume Estimation Using the Algan Method}
\usage{
algan_vta_vc22(data, output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements. Must include:
\itemize{
\item \code{species_code}: species name in uppercase Latin format (e.g. \code{"ABIES_ALBA"}).
\item \code{dbh}: diameter at breast height (cm).
\item \code{htot}: total tree height (m).
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A data frame with the original input columns plus two new outputs:
\itemize{
\item \code{algan_vta}: aerial total volume (m3). Computed only for \code{"ABIES_ALBA"}, \code{NA} otherwise.
\item \code{algan_vc22}: merchantable volume (m3). Computed only for compatible species
(\code{ABIES_ALBA}, \code{PICEA_ABIES}, \code{ALNUS_GLUTINOSA}, \code{PRUNUS_AVIUM}, \code{BETULA_SP}),
\code{NA} otherwise.
}
}
\description{
Computes aerial total volume (\code{algan_vta}) and merchantable volume (\code{algan_vc22})
according to the Algan method. The function validates input data, ensures
required columns are present and applies formulas only to compatible species.
}
\details{
\itemize{
\item Input \code{dbh} must be in centimeters (cm). The function converts it internally to meters.
\item Input \code{htot} must be in meters (m).
\item Formula for aerial total volume (only \code{"ABIES_ALBA"}):
\deqn{algan_vta = 0.4 * (dbh/100)^2 * htot}
\item Formula for merchantable volume (compatible species):
\deqn{algan_vc22 = 0.33 * (dbh/100)^2 * htot}
\itemize{
\item Domain of application:
\item For \code{"ABIES_ALBA"} and \code{"PICEA_ABIES"}, the Algan method is valid only if \verb{dbh > 15 cm}.
\item For other compatible species (\code{ALNUS_GLUTINOSA}, \code{PRUNUS_AVIUM}, \code{BETULA_SP}), no minimum dbh threshold is applied.
}
\item Resulting volumes are expressed in cubic meters (m3).
\item If required columns are missing or non-numeric, the function stops with an error.
\item Both output columns are always created to ensure consistency for downstream functions.
}
}
\examples{
df <- data.frame(
  species_code = c("ABIES_ALBA", "PICEA_ABIES", "BETULA_SP", "QUERCUS_ROBUR"),
  dbh = c(30, 25, 20, 40), 
  htot = c(20, 18, 15, 22)   
)
algan_vta_vc22(df)

}
