% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_output}
\alias{export_output}
\title{Export data frame to CSV with warnings instead of errors}
\usage{
export_output(data, output, verbose = FALSE)
}
\arguments{
\item{data}{A data.frame to export.}

\item{output}{Character string: path to the CSV file. If NULL, nothing is done.}

\item{verbose}{Logical. If TRUE, prints diagnostic messages. Default: FALSE.}
}
\value{
Invisibly returns \code{TRUE} if the export succeeded, \code{FALSE}
otherwise.
}
\description{
This function exports a data.frame to a CSV file. If \code{output} is NULL,
nothing is done. If the path is invalid or the export fails, a warning is
issued but the function does not stop, and still returns (invisibly) a
logical value indicating success.
}
\examples{
df <- data.frame(
  id = 1:3,
  volume = c(10.5, 12.3, 9.8)
)

export_output(df, file.path(tempdir(), "volumes.csv"))
}
