% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCES.R
\name{SCES}
\alias{SCES}
\title{Standard CES Function}
\usage{
SCES(sigma = 1 - 1/es, alpha, beta, x, es = NA)
}
\arguments{
\item{sigma}{the sigma coefficient.}

\item{alpha}{the alpha coefficient.}

\item{beta}{a vector consisting of the beta coefficients.}

\item{x}{a vector consisting of the inputs.}

\item{es}{the elasticity of substitution. If es is not NA, the value of sigma will be ignored.}
}
\value{
The output or utility level.
}
\description{
Standard CES function, e.g. alpha * (beta1 * (x1 / beta1)^sigma + beta2 * (x2 / beta2)^sigma)^(1 / sigma)
wherein beta1 + beta2 == 1.
}
\examples{
\donttest{
beta <- c(0.6, 0.4)
SCES(alpha = 1, beta = beta, x = beta, es = 0.5)
}

}
