% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_thinning.R
\name{compute_neighbors_kdtree}
\alias{compute_neighbors_kdtree}
\title{Compute Neighbors Using kd-Tree}
\usage{
compute_neighbors_kdtree(
  coordinates,
  thin_dist,
  k = NULL,
  distance = c("haversine", "euclidean"),
  R = 6371
)
}
\arguments{
\item{coordinates}{A matrix of coordinates to thin, with two columns representing longitude and latitude.}

\item{thin_dist}{A positive numeric value representing the thinning distance in kilometers.}

\item{k}{An integer specifying the maximum number of neighbors to consider for each point.}

\item{distance}{A character string specifying the distance metric to use `c("haversine", "euclidean")`.}

\item{R}{A numeric value representing the radius of the Earth in kilometers. The default is 6371 km.}
}
\value{
A list where each element corresponds to a point and contains the indices of its neighbors, excluding the point itself.
}
\description{
Computes neighbors for each point in a set of coordinates using a kd-tree
for efficient neighbor searches. This method is particularly useful for large datasets.
}
\details{
This function uses kd-tree (via `nabor` package) for efficient spatial searches. The kd-tree inherently works with Euclidean distances.
If `"haversine"` is selected, the function first converts geographic coordinates to 3D Cartesian coordinates before constructing the kd-tree.
}
\examples{
set.seed(123)
coords <- matrix(runif(20, min = -180, max = 180), ncol = 2)

# Compute neighbors using kd-tree
neighbors <- compute_neighbors_kdtree(coords, thin_dist = 10,)

}
