% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_search.R
\name{optimize_asymmetric_treatment_assignment}
\alias{optimize_asymmetric_treatment_assignment}
\title{Compute Optimal Number of Treatments/Controls}
\usage{
optimize_asymmetric_treatment_assignment(
  c_treatment = NULL,
  c_control = NULL,
  c_total_max = NULL,
  n = NULL
)
}
\arguments{
\item{c_treatment}{The cost of a treatment assignment. Default is \code{NULL} for symmetric costs.}

\item{c_control}{The cost of a control assignment. Default is \code{NULL} for symmetric costs.}

\item{c_total_max}{The total cost constraint of any allocation. Either this or \code{n} must be specified. Default is \code{NULL}.}

\item{n}{The total cost constraint as specified by the total number of subjects. Either this or \code{c_total} must be 
specified. Default is \code{NULL}.}
}
\value{
A list with three keys: n, nT, nC plus specified arguments
}
\description{
Given a total budget and asymmetric treatment and control costs, calculate the
number of treatments and controls that optimize the variance of the estimator. 
The number of treatments is rounded up by default.
}
\examples{
\dontrun{
optimize_asymmetric_treatment_assignment(n = 100)
optimize_asymmetric_treatment_assignment(n = 100, c_treatment = 2, c_control = 1)
optimize_asymmetric_treatment_assignment(c_total_max = 50, c_treatment = 2, c_control = 1)
}
}
\author{
Adam Kapelner
}
