% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gul_simulation.R
\name{gul_simulation}
\alias{gul_simulation}
\title{Single-replication GUL simulation}
\usage{
gul_simulation(n, p, m, g_fun)
}
\arguments{
\item{n}{Integer: sample size.}

\item{p}{Integer: number of observed variables.}

\item{m}{Integer: number of latent factors (both layers).}

\item{g_fun}{Function: element-wise, smooth transformation applied to the
latent factors (e.g. `tanh`, `sin`).}
}
\value{
Named numeric vector with components
  error_F      : Frobenius norm ||hat(Ag) - Ag||_F
}
\description{
Generates one synthetic data set, estimates loadings with the GUL, and evaluates estimation accuracy.
}
\examples{
gul_simulation(200, 50, 5, g_fun = tanh)
}
