% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_dependency.R
\name{add_stat_dependency}
\alias{add_stat_dependency}
\title{Calculates confidence limits}
\usage{
add_stat_dependency(
  calc_dat,
  confidence_level = 0.98,
  theoretical = FALSE,
  fractional = TRUE
)
}
\arguments{
\item{calc_dat}{data produced by \code{\link{calculate_diff_uptake}}
function.}

\item{confidence_level}{confidence limit - from range [0, 1].}

\item{theoretical}{\code{logical}, determines if values are theoretical.}

\item{fractional}{\code{logical}, determines if values are fractional.}
}
\value{
calc_dat extended by column specifying if given peptide is relevant in
given confidence limit. The value of the confidence limit is added as an attribute 
- as well as parameters used to calculate (theoretical/fractional).
}
\description{
Returns relation with confidence limits for each peptide.
}
\details{
This function checks if the values are statistically significant based 
on provided criteria using Houde test.
}
\examples{
calc_dat <- calculate_diff_uptake(alpha_dat)
result <- add_stat_dependency(calc_dat)
head(result)                            

}
