% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_auc.R
\name{calculate_auc}
\alias{calculate_auc}
\title{Calculate Area Under the Curve}
\usage{
calculate_auc(
  uptake_dat,
  protein = uptake_dat[["Protein"]][1],
  state = uptake_dat[["State"]][1],
  preserve_values = FALSE
)
}
\arguments{
\item{uptake_dat}{data with deuterium uptake values, 
calculated e.q. by \code{\link{create_uptake_dataset}}}

\item{protein}{chosen protein}

\item{state}{state included in calculations}

\item{preserve_values}{indicator if the original columns
form uptake_dat should be preserve in the result}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Calculates area under the deuterium uptake curve
}
\details{
The AUC is calculated on the data normalized to unit square by 
division by maximum values of exposure time and deuterium uptake, 
respectively.
}
\examples{
uptake_dat <- create_uptake_dataset(alpha_dat)
head(calculate_auc(uptake_dat))

}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_uptake_dataset}}
}
