% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_chiclet.R
\name{plot_chiclet}
\alias{plot_chiclet}
\title{Chiclet deuterium uptake plot}
\usage{
plot_chiclet(
  uptake_dat,
  theoretical = FALSE,
  fractional = FALSE,
  show_uncertainty = FALSE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{uptake_dat}{produced by \code{\link{create_state_uptake_dataset}}
function.}

\item{theoretical}{\code{logical}, determines if values are theoretical.}

\item{fractional}{\code{logical}, determines if values are fractional.}

\item{show_uncertainty}{\code{logical}, determines if the
uncertainty is shown.}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Chiclet plot of deuterium uptake values in time
for one biological state.
}
\details{
Function \code{\link{plot_chiclet}} produces a chiclet
plot based on the same dataset as butterfly plot, as it is the different
form of presenting the same data. On X-axis there is a peptide ID. On 
Y-axis are time points of measurement. Each tile for a peptide in time has
a color value representing the deuterium uptake, in a form based on 
provided criteria (e.q. fractional). Each tile has a plus sign, which size 
represent the uncertainty of measurement for chosen value.
}
\examples{
state_uptake_dat <- create_state_uptake_dataset(alpha_dat)
plot_chiclet(state_uptake_dat)

}
\seealso{
\code{\link{create_state_uptake_dataset}}
}
