% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_uncertainty.R
\name{plot_uncertainty}
\alias{plot_uncertainty}
\title{Uncertainty of the peptide measurements}
\usage{
plot_uncertainty(
  dat,
  protein = dat[["Protein"]][1],
  state = dat[["State"]][1],
  skip_amino = 0,
  aggregated = TRUE,
  separate_times = TRUE,
  show_threshold = TRUE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{selected protein}

\item{state}{selected biological state for given protein}

\item{skip_amino}{\code{integer}, indicator how many amino acids from the N-terminus 
should be omitted}

\item{aggregated}{\code{logical}, indicator if presented
data is aggregated on replicate level}

\item{separate_times}{\code{logical}, indicator if the 
values for different time points are presented separately}

\item{show_threshold}{\code{logical}, indicator if the 
threshold of significance is shown}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app)}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot the uncertainty of the mass measurements - 
for aggregated data or before aggregation - to see if there is 
a region with uncertainty higher than acceptable
}
\details{
The function \code{\link{plot_uncertainty}} generates 
a plot of uncertainty of mass measurement of each peptide from
selected protein in selected biological state. The values can be presented 
in two ways: as aggregated values for each replicate, or before
aggregation - measured values for charge values within a replicate.
On X-axis there is a position in a sequence, with length of a segment 
of each peptide representing its length. On Y-axis there 
is uncertainty of the measurement in Daltons.
The threshold is set to 1 Da, as this value is associated with exchange.
}
\examples{
plot_uncertainty(alpha_dat)
plot_uncertainty(alpha_dat, aggregated = FALSE)
plot_uncertainty(alpha_dat, aggregated = FALSE, separate_times = FALSE)
plot_uncertainty(alpha_dat, skip_amino = 1)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses}}
}
