% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_uptake_data}
\alias{show_uptake_data}
\title{Deuterium uptake data}
\usage{
show_uptake_data(
  uptake_dat,
  theoretical = FALSE,
  fractional = FALSE,
  renamed = TRUE
)
}
\arguments{
\item{uptake_dat}{data produced by \code{\link{create_uptake_dataset}} 
function or \code{\link{create_state_uptake_dataset}}}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{renamed}{\code{logical}, indicator if the names of the columns
are renamed to user-friendly ones. Currently FALSE not implemented.}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Present deuterium uptake values 
in selected form
}
\details{
The function \code{\link{show_uptake_data}} generates a subsets
of the uptake_dat based on selected parameters.
The numerical values are rounded to 4 places. The names of columns
are changed to user-friendly ones.
}
\examples{
uptake_dat <- create_uptake_dataset(alpha_dat)
show_uptake_data(uptake_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{create_uptake_dataset}}
}
