% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_hdexaminer_file.R
\name{update_hdexaminer_file}
\alias{update_hdexaminer_file}
\title{Update HDeXaminer datafile}
\usage{
update_hdexaminer_file(
  dat,
  fd_time,
  old_protein_name = NULL,
  new_protein_name = NULL,
  old_state_name = NULL,
  new_state_name = NULL,
  confidence = c("High", "Medium")
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{fd_time}{time point [min] for fully deuterated sample}

\item{old_protein_name}{protein name to be changed}

\item{new_protein_name}{new name for old_protein_name}

\item{old_state_name}{state names to be changed}

\item{new_state_name}{new names for old_state_name}

\item{confidence}{vector of accepted confidence values 
(internal flag from HDeXaminer). By default only
accepted values are `Medium` and `High`, with `Low` excluded}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Update data from HDeXaminer file
}
\details{
The function \code{\link{update_hdexaminer_file}}
changes the data read from HDeXaminer file.
Data from HDeXaminer is condensed and automated 
data retrieving may be corrected by the user. 
The original file has a mark "FD" for fully deuterated 
data instead of numerical value for time point  
(provided in minutes) that is not consistent for workflow
and not enough for precise data description.
Moreover, the data about both protein and state is included
in one column and for detailed information
function \code{\link{update_hdexaminer_file}} allows to change them.
}
\seealso{
\code{\link{read_hdx}} 
\code{\link{calculate_kinetics}} 
\code{\link{plot_coverage}} 
\code{\link{plot_position_frequency}}
\code{\link{reconstruct_sequence}}
}
