% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsn.R
\name{qsnorm_fast}
\alias{qsnorm_fast}
\title{Fast Approximation of Skew-Normal Quantile Function}
\usage{
qsnorm_fast(p, xi = 0, omega = 1, alpha = 0)
}
\arguments{
\item{p}{Vector of probabilities.}

\item{xi}{Location parameter (numeric vector).}

\item{omega}{Scale parameter (numeric vector).}

\item{alpha}{Shape parameter (numeric vector).}
}
\value{
Vector of quantiles.
}
\description{
A fast approximation of skew-normal quantiles using the high-performance
approximation algorithm from the INLA GMRFLib C source, and originally by
Thomas Luu (see details for reference).
}
\details{
This function implements a high-performance approximation for the
skew-normal quantile function based on the algorithm described by Luu
(2016). The method uses a domain decomposition strategy to achieve high
accuracy (\eqn{< 10^{-7}} relative error) without iterative numerical
inversion.

The domain is split into two regions:
\itemize{
\item \strong{Tail Regions:} For extreme probabilities where \eqn{\vert u \vert} is large, the quantile
is approximated using the Lambert W-function, \eqn{W(z)}, solving \eqn{z = \Phi(q)} via
asymptotic expansion:
\deqn{q \approx \sqrt{2 W\left(\frac{1}{2\pi (1-p)^2}\right)}}
\item \strong{Central Region:} For the main body of the distribution, the function
uses a high-order Taylor expansion of the inverse error function around a
carefully selected expansion point $x_0$:
\deqn{\Phi^{-1}(p) \approx \sum_{k=0}^5 c_k (z - x_0)^k}
}

This approach is significantly faster than standard numerical inversion
(e.g., \code{uniroot}) while maintaining sufficient precision for most
statistical applications.
}
\references{
Luu, T. (2016). \emph{Fast and accurate parallel computation of
quantile functions for random number generation} #' (Doctoral thesis). UCL
(University College London). \url{https://discovery.ucl.ac.uk/1482128/}
}
