% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_sl.R
\name{pick_sl}
\alias{pick_sl}
\title{Pick Super Lotto numbers}
\usage{
pick_sl(size = 1L, verbose = TRUE)
}
\arguments{
\item{size}{An integer. The size of sets of Super Lotto numbers to pick.}

\item{verbose}{A logical value. Print the numbers picked or not.}
}
\value{
Print the numbers picked, and return the invisible \code{balls} list that stored these numbers.
}
\description{
Pick Super Lotto numbers
}
\examples{
# Example 1
pick_sl(10)
# Example 2
out <- pick_sl(10, verbose = FALSE)
out
# Example 3
# create an empty list
balls <- list(c(front = rep(NA, 5),
                back = rep(NA, 2))
)
luck <- list(c(front = c(10L, 13L, 14L, 19L, 27L),
               back = c(6L, 10L)))
# limit the max number of draws
max <- 9999
# try
# count the number of draws
i <- 0
while (!identical(balls, luck, max)) {
  i = i + 1
  balls = pick_sl(verbose = FALSE)
  if (identical(balls, luck)) {
    print(i)
    print(balls)
  }
  else
    if (i == max) {
      cat(i, "failed\n")
      break}
}
}
