% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_explanations.R
\name{get_local_explanations_gradient}
\alias{get_local_explanations_gradient}
\title{Function to get gradient based local explanations for input-skip LBBNNs.}
\usage{
get_local_explanations_gradient(
  model,
  input_data,
  num_samples = 1,
  magnitude = TRUE,
  include_potential_contribution = FALSE,
  device = "cpu"
)
}
\arguments{
\item{model}{A \code{LBBNN_Net} with input-skip}

\item{input_data}{The data to be explained (one sample).}

\item{num_samples}{integer, how many samples to use to produce credible intervals.}

\item{magnitude}{If TRUE, only return explanations. If FALSE, multiply by input values.}

\item{include_potential_contribution}{IF TRUE, If covariate=0,
we assume that the contribution is negative (good/bad that it is not included)
if FALSE, just removes zero covariates.}

\item{device}{character, the device to be trained on. Default is 'cpu', can be 'mps' or 'gpu'.}
}
\value{
A list with the following elements:
\describe{
\item{explanations}{A \code{torch::tensor} of shape (num_samples, p, num_classes).}
\item{p}{integer, the number of input features.}
\item{predictions}{A \code{torch::tensor} of shape (num_samples, num_classes).}
}
}
\description{
Works by computing the gradient wrt to input, given we have
relu activation functions.
}
