% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_utils.R
\name{mx_to_e0}
\alias{mx_to_e0}
\title{calculate life expectancy at birth from mortality rates}
\usage{
mx_to_e0(mx, age, sex = "t", nx = rep(1, length(age)), closeout = TRUE)
}
\arguments{
\item{mx}{numeric vector of the mortality rates (central death rates)}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{sex}{character: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{nx}{age interval width, assumes 1 by default}

\item{closeout}{logical. Default \code{TRUE}.}
}
\value{
numeric scalar of \code{e0}
}
\description{
We follow the full chain of standard lifetable column calculations to translate \code{mx} to \code{ex}, then select the first element of \code{ex}. If \code{min(age) > 0}, then we return remaining life expectancy at the lowest given age.
}
