% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_custom_agent.R
\name{build_custom_agent}
\alias{build_custom_agent}
\title{Build a Custom Graph-Based Agent}
\usage{
build_custom_agent(
  node_functions,
  entry_point,
  edges = list(),
  conditional_edges = list(),
  default_state = list(),
  checkpointer = NULL,
  output = c("agent", "mermaid", "both"),
  direction = c("TD", "LR"),
  subgraphs = NULL,
  style = TRUE
)
}
\arguments{
\item{node_functions}{Named list of node functions. Each function takes `state`
and returns a named list or [make_command()].}

\item{entry_point}{Name of the start node (must exist in `node_functions`).}

\item{edges}{Optional list of static edges. Each item can be:
- a character vector of length 2: `c("from", "to")`, or
- a list with `from` and `to`.}

\item{conditional_edges}{Optional list where each item contains:
- `from` (or `node_name`),
- `condition` (or `condition_fun`),
- `mapping` (or `mapping_list`) as a named list of label -> node.}

\item{default_state}{Optional named list merged into `state` for missing keys.}

\item{checkpointer}{Optional callback `function(state, current_node)` executed
after each transition.}

\item{output}{Output mode:
- `"agent"` (default): return runnable agent function,
- `"mermaid"`: return Mermaid text only,
- `"both"`: return list with `run`, `graph`, and `mermaid`.}

\item{direction}{Mermaid direction used when `output` includes Mermaid.}

\item{subgraphs}{Optional named list of subgraph groups for Mermaid rendering.}

\item{style}{Logical; include default Mermaid class styling.}
}
\value{
- If `output = "agent"`: a function that accepts `state` and returns final state.
- If `output = "mermaid"`: Mermaid flowchart text.
- If `output = "both"`: list with `run`, `graph`, and `mermaid`.
}
\description{
Build a reusable agent by wiring user-defined node functions into a state graph.
This is the public extension point for creating custom LLMAgentR workflows.
}
\examples{
\dontrun{
custom <- build_custom_agent(
  node_functions = list(
    start = function(state) make_command("classify"),
    classify = function(state) {
      if (grepl("weather", state$query, ignore.case = TRUE)) {
        make_command("weather")
      } else {
        make_command("general")
      }
    },
    weather = function(state) list(answer = "Routing to weather handler"),
    general = function(state) list(answer = "Routing to general handler")
  ),
  entry_point = "start",
  edges = list(c("weather", "__end__"), c("general", "__end__")),
  output = "both",
  subgraphs = list(
    Router = c("start", "classify"),
    Handlers = c("weather", "general")
  )
)

cat(custom$mermaid)
custom$run(list(query = "weather in Accra"))
}

}
