% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par.to.sw.R
\name{par.to.sw}
\alias{par.to.sw}
\alias{par.to.sw.base}
\title{Convert PAR to shortwave}
\usage{
par.to.sw.base(par, coeff=0.473)

par.to.sw(data, par.col='par', coeff=0.473)
}
\arguments{
\item{data}{Object of class data.frame with column name 'par' (units umol/m^2/sec)}

\item{par.col}{String of alternative name for PAR column}

\item{coeff}{Numerical coefficient to convert PAR (umol/m^2/sec) to SW (W/m^2). 
Defaults to value from Britton and Dodd (1976).}

\item{par}{Numeric vector of PAR values (umol/m^2/sec)}
}
\value{
#For par.to.sw

Object of class data.frame with column name 'sw' and other values from \code{ts.data}

#For par.to.sw.base

Numeric vector of shortwave values with units W/m^2
}
\description{
Returns incoming shortwave radiation by converting PAR measuremt.
}
\examples{
par <- 800
par.to.sw.base(par)
}
\references{
Britton, C. M., and J. D. Dodd. \emph{Relationships of photosynthetically active radiation and shortwave irradiance.} 
Agricultural Meteorology 17, no. 1 (1976): 1-7.
}
\seealso{
\link{sw.to.par}
}
\author{
LakeMetabolizer
}
\keyword{math}
\keyword{methods}
