% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-fit.R
\name{PLR.fit}
\alias{PLR.fit}
\title{Penalized Lorenz Regression Fit Function}
\usage{
PLR.fit(y, x, weights = NULL, penalty, grid.arg, grid.value, lambda.list, ...)
}
\arguments{
\item{y}{A numeric vector representing the response variable.}

\item{x}{A numeric matrix of covariates.}

\item{weights}{An optional numeric vector of sample weights. Default is \code{NULL}.}

\item{penalty}{A character string specifying the penalty type. Possible values are \code{"LASSO"} and \code{"SCAD"}.}

\item{grid.arg}{A character string specifying the tuning parameter for which a grid is constructed.}

\item{grid.value}{A numeric vector specifying the grid values for \code{grid.arg}. If \code{NULL}, no grid is constructed.}

\item{lambda.list}{An optional list specifying penalty values (\eqn{\lambda}) to be used for each grid value.}

\item{...}{Additional arguments passed to \code{\link{Lorenz.FABS}} or \code{\link{Lorenz.SCADFABS}}, depending on the penalty type.}
}
\value{
A list containing:
\describe{
  \item{\code{path}}{A list of matrices, where each element corresponds to a grid value. Each matrix contains lambda values, Lorenz-\eqn{R^2}, explained Gini coefficients, BIC scores, and estimated coefficients.}
  \item{\code{grid.idx}}{The index of the optimal grid parameter selected by the BIC criterion.}
  \item{\code{lambda.idx}}{The index of the optimal \eqn{\lambda} selected by the BIC criterion.}
  \item{\code{grid.value}}{The grid values used for \code{grid.arg}.}
  \item{\code{lambda.list}}{A list of \eqn{\lambda} values along the solution paths.}
  \item{\code{grid.arg}}{The tuning parameter for which the grid was constructed.}
}
}
\description{
\code{PLR.fit} fits a penalized Lorenz regression model using either the LASSO or SCAD penalty.
It serves as an internal wrapper that applies the fit function over a grid of tuning parameter values.
}
\details{
The function applies either \code{\link{Lorenz.FABS}} (for LASSO) or \code{\link{Lorenz.SCADFABS}} (for SCAD) for each grid value.
The best model is selected based on the BIC score.
}
\examples{
data(Data.Incomes)
y <- Data.Incomes$Income
x <- as.matrix(Data.Incomes[,-c(1,2)])
PLR.fit(y, x, penalty = "SCAD", grid.arg = "eps", grid.value = c(0.2,0.5), lambda.list = NULL)

}
\seealso{
\code{\link{Lorenz.FABS}}, \code{\link{Lorenz.SCADFABS}}, \code{\link{Lorenz.boot}}, \code{\link{Lorenz.Reg}}
}
