% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmad.R
\name{varmad}
\alias{varmad}
\title{Approximate Variance of the Median Absolute Deviation (MAD) Estimator.}
\usage{
varmad(x, constant = 1.4826, use.gld = FALSE, gld.est = "TM", ...)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{constant}{a scale factor. Default choice ensures population mad is equal to the SD for normal distributions.}

\item{use.gld}{a logical indicating whether to use the flexible Generalised Lambda Distribution (GLD) to estimate the density and distribution function.}

\item{gld.est}{a character string indicating which estimator of the GLD parameters is to be used if \code{use.gld=TRUE}.}

\item{...}{additional arguments, if desired, to be passed to function density for density estimation (see help file for \code{\link[=density]{density()}} for more details).}
}
\value{
A number which is the estimated approximate variance of the mad estimator
}
\description{
This function calculates the approximate (large-sample) variance of the MAD estimator.
}
\details{
This function calculates an approximate variance for the traditional Median of Absolute Deviations (MAD) estimator.
The variance requires estimation of the probability density function and the distribution function which, by default, is carried out
using the \code{density()} and \code{ecdf()} functions respectively.  An alternative is to use the flexible four-parameter Generalised Lambda Distribution (GLD)
to estimate these functions.  This is done by using \code{use.gld = TRUE} and the default estimator is \code{gld.est = TM} for
Titterington's Method (Titterington, 1985).  Other estimators are available and further details can be found in the \link[gld:fit.fkml]{gld::fit.fkml} documentation from the \code{gld} package
(King et al., 2022).  For further details on the approximate variance see Arachchige and Prendergast (2024).
}
\examples{
# Create some data
set.seed(1234)
x <- rlnorm(100)

# Calculate the mad and its variance
mad.est <- mad(x)
mad.est
v.est <- varmad(x)
v.est

# Calculate an approximate 95\% confidence interval for the true mad
mad.est + c(-1, 1) * qnorm(0.975) * sqrt(v.est)
}
\references{
Arachchige, C.N.P.G., & Prendergast, L.A. (2026). Confidence intervals for median absolute deviations. Communications in Statistics-Simulation and Computation, 55(1), 13-22.

King R, Dean B, Klinke S, & van Staden, P (2022). gld: Estimation and Use of the Generalised (Tukey) Lambda Distribution. R package version 2.6.6, \url{https://CRAN.R-project.org/package=gld}.

Titterington, D. M. (1985), Comment on ‘Estimating Parameters in Continuous Univariate Distributions', Journal of the Royal Statistical Society, Series B, 47, 115–116.
}
