#' Assembly function: Logarithmic function
#'
#' This function evaluates the logarithmic function \deqn{f(x_1,x_2,\ldots,x_k)=\log(\sum_{i=1}^kc_ix_{i}).}
#'
#' @param parameter The value of the parameters \eqn{x_1,x_2,\ldots,x_k}.
#' @param coefficient The value of the coefficients \eqn{c_1,c_2,\ldots,c_k}.
#'
#' @return
#' Value of the logarithmic function.
#'
#' @keywords internal
#' @noRd
Logarithmic<-function(parameter,coefficient)
{
  return(log(sum(coefficient*parameter)))
}
