% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_prop.R
\name{h_prop}
\alias{h_prop}
\alias{h.prop}
\title{Cohen's h for Independent Proportions}
\usage{
h_prop(p1, p2, n1, n2, a = 0.05)

h.prop(p1, p2, n1, n2, a = 0.05)
}
\arguments{
\item{p1}{Proportion for group one (between 0 and 1).}

\item{p2}{Proportion for group two (between 0 and 1).}

\item{n1}{Sample size for group one.}

\item{n2}{Sample size for group two.}

\item{a}{Significance level used for confidence intervals. Defaults to 0.05.}
}
\value{
A list containing Cohen's \eqn{h} effect size and related statistics:
\itemize{
  \item `h` – Cohen's h.
  \item `hlow`, `hhigh` – lower and upper confidence interval limits.
  \item `h_lower_limit`, `h_upper_limit` – snake_case aliases for the
    confidence limits.
  \item `p1`, `p2` – input proportions for each group.
  \item `n1`, `n2` – sample sizes for each group, with snake_case
    aliases `sample_size_1`, `sample_size_2`.
  \item `z`, `p` – z statistic and p value for the difference in
    proportions using a pooled-proportion standard error.
  \item `z_value`, `p_value` – snake_case aliases for the z statistic
    and p value.
  \item `estimate` – APA-style formatted string for
    Cohen's h and its confidence interval.
  \item `statistic` – APA-style formatted string
    for the z test of the difference in proportions.
}
}
\description{
This function computes Cohen's \eqn{h} effect size for the difference
between two independent proportions. Cohen's \eqn{h} is defined as a
difference between arcsine-transformed proportions:
}
\details{
\deqn{h = 2 \arcsin \sqrt{p_1} - 2 \arcsin \sqrt{p_2}}

where \eqn{p_1} and \eqn{p_2} are proportions for groups 1 and 2,
respectively.

Using a simple large-sample approximation (via the delta method), the
standard error of \eqn{h} can be taken as:

\deqn{\mathrm{SE}(h) \approx \sqrt{1 / n_1 + 1 / n_2}},

which leads to a \eqn{(1 - \alpha)} confidence interval for \eqn{h}:

\deqn{h \pm z_{1 - \alpha/2} \, \mathrm{SE}(h).}

This effect size is commonly recommended for differences in proportions
(Cohen, 1988) and is particularly useful for power analysis and
meta-analysis when working directly with proportions.
}
\examples{
h_prop(p1 = .25, p2 = .35, n1 = 100, n2 = 100, a = .05)
}
