% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{makefile}
\alias{makefile}
\title{Creates a Makefile}
\usage{
makefile(..., .dots = NULL)
}
\arguments{
\item{...}{\code{[MakefileR]}\cr Items created by \code{\link{make_rule}} or other \code{make_}
functions}

\item{.dots}{\code{[list]}\cr Further rules in addition to \code{...}}
}
\value{
An object of class \code{MakefileR_file}
}
\description{
A \code{Makefile} consists of a list of rules, definition, comments
and other items.
}
\details{
Use the
\code{\link[base]{c}} function or the \code{\link[base]{+}} operator
to append rules, definitions, comments, plain text, and groups.
}
\examples{
makefile(make_rule("all", c("first_target", "second_target")))

}
\references{
https://www.gnu.org/software/make/manual/
}
\seealso{
\code{\link{make_rule}}, \code{\link{make_def}},
  \code{\link{make_comment}}, \code{\link{make_text}}, \code{\link{make_group}},
  \code{\link{c.MakefileR_group}}
}
