% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Marginal_Mediation.R
\name{mma}
\alias{mma}
\title{Marginal Mediation}
\usage{
mma(..., ind_effects, ci_type = "perc", boot = 500, ci = 0.95)
}
\arguments{
\item{...}{the glm model objects; the first is the model with the outcome while the others are the mediated effects ("a" paths)}

\item{ind_effects}{a vector of the desired indirect effects. Has the form \code{"var1-var2"}.}

\item{ci_type}{a string indicating the type of bootstrap method to use (currently "perc" and "basic" are available; "perc" is recommended). Further development will allow the Bias-Corrected bootstrap soon.}

\item{boot}{the number of bootstrapped samples; default is 500.}

\item{ci}{the confidence interval; the default is .95 which is the 95\% confidence interval.}
}
\value{
A list of class \code{mma} containing:
\item{ind_effects}{the indirect effects reported in the average marginal effect}
\item{dir_effects}{the direct effects reported in the average marginal effect}
\item{ci_level}{the confidence level}
\item{data}{the original data frame}
\item{reported_ind}{the indirect effects the user requested (in the \code{...})}
\item{boot}{the number of bootstrap samples}
\item{model}{the formulas of the individual sub-models}
\item{call}{the original function call}
}
\description{
Provides the ability to perform marginal mediation. Marginal mediation
is particularly useful for situations where the mediator or outcome is categorical,
a count, or some other non-normally distributed variable.
The results provide the average marginal effects of the models, providing simple
interpretation of the indirect effects.
}
\details{
Using the average marginal effects as discussed by Tamas Bartus (2005), 
the coefficients are transformed into probabilities (for binary outcomes) or remain
in their original units (continuous outcomes).
}
\examples{

## A minimal example:

library(furniture)
data(nhanes_2010)
bcpath = glm(marijuana ~ home_meals + gender + age + asthma, 
           data = nhanes_2010, 
           family = "binomial")
apath = glm(home_meals ~ gender + age + asthma,
           data = nhanes_2010, 
           family = "gaussian")
(fit = mma(bcpath, apath, 
           ind_effects = c("genderFemale-home_meals",
                           "age-home_meals",
                           "asthmaNo-home_meals"),
           boot = 10))

}
\references{
Bartus, T. (2005). Estimation of marginal effects using margeff. 
The Stata Journal, 5(3), 309–329.

MacKinnon, D. (2008). Introduction to Statistical Mediation Analysis. 
Taylor & Francis, LLC.
}
\author{
Tyson S. Barrett
}
