% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msconvert.R
\name{msconvert}
\alias{msconvert}
\title{msconvert.}
\usage{
msconvert(
  files = NULL,
  msc_exe =
    "C:\\\\Program Files\\\\ProteoWizard\\\\ProteoWizard 3.0.11856\\\\msconvert.exe",
  out_path = NULL,
  args = c("--filter \\"peakPicking cwt snr=0.01 peakSpace=0.1 msLevel=1\\"",
    "--filter \\"scanTime [0,3600]\\"", "--filter \\"metadataFixer\\"", "--mzML", "--32",
    "--zlib")
)
}
\arguments{
\item{files}{A character vector of MS data files (wiff, raw, d, ...). If unspecified, function will return the args to msconvert.}

\item{msc_exe}{The path to the installed `msconvert.exe`.}

\item{out_path}{Specify valid path or keep NULL to write output in same folder as input.}

\item{args}{The arguments passed to msconvert on the command line (see details for documentation). Can be a keyword describing a predefined set (currently: 'default' and 'sciex_MS2' are available)}
}
\value{
Only some informative outputs printed to the console. The specified MS data
  files will be converted to mzML within the input folder.
}
\description{
\code{msconvert} is calling ProteoWizards MSConvert as a command line tool on Windows.
}
\details{
It is a quick and dodgy function to show how to convert vendor MS data
  into an open format (mzML). You will have to download/install MSConvert prior
  to usage, and probably adjust the arguments according to your needs. Arguments
  are documented here \url{https://proteowizard.sourceforge.io/tools/msconvert.html}.
  If you don't know where the msconvert.exe is installed you can check for the correct
  path using \code{list.files(path="C:/", pattern="^msconvert.exe$", recursive = TRUE)}.
  You may read on the potential arguments calling msconvert with the argument '--help',
  system2(command = 'path/to/msconvert.exe', args = "--help").
}
\examples{
msconvert()

}
