## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(MultiStatM)

## -----------------------------------------------------------------------------
PTA<-PartitionTypeAll(4)

## -----------------------------------------------------------------------------
PTA$S_N_r

## -----------------------------------------------------------------------------
PTA$Part.class[[2]]

## -----------------------------------------------------------------------------
PTA$Part.class[[10]] 

## -----------------------------------------------------------------------------
PTA$S_r_j[[2]] 

## -----------------------------------------------------------------------------
PTA$eL_r

## -----------------------------------------------------------------------------
a1<-c(1,2)
a2<-c(2,3,4)
a3<-c(1,3)
p1<-a1%x%a2%x%a3
c(CommutatorMatr(Type="Kperm",c(3,1,2),c(2,3,2))%*%p1) 
a3%x%a1%x%a2 

## -----------------------------------------------------------------------------
p1[CommutatorIndx(Type="Kperm",c(3,1,2),c(2,3,2))]

## -----------------------------------------------------------------------------
a<-c(1,2)
a3<-a%x%a%x%a
a3
c(EliminMatr(2,3)%*%a3)
c(QplicMatr(2,3)%*%EliminMatr(2,3)%*%a3)

## -----------------------------------------------------------------------------
x<-c(1,2,3)
H2<-HermiteN(x,N=2,Type="Multivariate")
H2[[1]]
H2[[2]]

## -----------------------------------------------------------------------------
H2<-HermiteN(x,Sig2=4*diag(3),N=2,Type="Multivariate")
H2[[1]]
H2[[2]]

## -----------------------------------------------------------------------------
HermiteN2X(H2,N=2,Sig2=4*diag(3),Type="Multivariate")[[1]] 

## -----------------------------------------------------------------------------
Covmat<-matrix(c(1,0.8,0.3,0.8,2,1,0.3,1,2),3,3)
Cov_X1_X2 <- HermiteCov12(SigX12=Covmat,N=3)

## -----------------------------------------------------------------------------
mu<-list(c(1,1),c(2,1.5,1.5,2),c(4,3,3,3,3,3,3,4),c(10,7,7,6.5,7,6.5,6.5,7,7,6.5,6.5,7,6.5,7,7,10))
cum<-Mom2Cum(mu, Type="Multivariate")
cum

## -----------------------------------------------------------------------------
Cum2Mom(cum,Type="Multivariate")

## -----------------------------------------------------------------------------
mu[[3]][EliminIndx(2,3)]

## -----------------------------------------------------------------------------
r.mu<-EliminMatr(2,3)%*% mu[[3]]
c(r.mu)

## -----------------------------------------------------------------------------
c(QplicMatr(2,3)%*%r.mu)

## -----------------------------------------------------------------------------
r.mu[QplicIndx(2,3)]

## -----------------------------------------------------------------------------
alpha<-c(10,5,0)
omega<-diag(3)
MSN<-MomCumSkewNorm(r=3,omega,alpha,nMu=TRUE)
round(MSN$Mu[[3]],3)
round(MSN$CumX[[3]],3)

## -----------------------------------------------------------------------------
EVSKUniS(3,  Type="Standard")$Kurt.U

## -----------------------------------------------------------------------------
data<-rSkewNorm(1000,omega,alpha)
EsMSN<-SampleEVSK(data)
ThMSN<-EVSKSkewNorm(omega,alpha)

## -----------------------------------------------------------------------------
EsMSN$estSkew[EliminIndx(3,3)]   
ThMSN$SkewX[EliminIndx(3,3)]   


## -----------------------------------------------------------------------------
EsMSN$estSkew[MargMomCum(3,3)]  ## Get univariate skewness for X1,X2,X3
EsMSN$estKurt[MargMomCum(3,4)]  ## Get univariate kurtosis for X1,X2,X3

## -----------------------------------------------------------------------------
SampleSkew(data,Type="Mardia")
ThMSN$SkewX.tot

## -----------------------------------------------------------------------------
SampleSkew(data,Type="MRSz")
as.vector(t(c(diag(3))%x%diag(3))%*%ThMSN$SkewX)

## -----------------------------------------------------------------------------
c(t(c(diag(3))%x%diag(3))%*%ThMSN$SkewX)  ## Theoretical MRS skewness vector

