% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{MomCumGenHyp}
\alias{MomCumGenHyp}
\title{Moments and cumulants of the multivariate
Generalized Hyperbolic distribution}
\usage{
MomCumGenHyp(r = 4, lambda, chi, psi, mu, sigma, gamma, nMu = FALSE)
}
\arguments{
\item{r}{highest order of moments and cumulants}

\item{lambda}{scalar valued}

\item{chi}{scalar valued}

\item{psi}{scalar valued}

\item{mu}{a vector of dimension d}

\item{sigma}{a dxd covariance matrix}

\item{gamma}{a scalar value}

\item{nMu}{if it is TRUE then moments are calculated}
}
\value{
The list of moments (or cumulants) in vector form
}
\description{
Computes cumulants and moments up to order r=6 of the d-variate Generalized
Hyperbolic distribution \eqn{\mathcal{GH}\left( \lambda
,\chi ,\psi ,\boldsymbol{\mu },\boldsymbol{\Sigma },\boldsymbol{\gamma }%
\right)}
defined as
 \deqn{\mathbf{X}=\boldsymbol{\mu }+V\boldsymbol{\gamma }+\sqrt{V}\boldsymbol{%
\Sigma }^{1/2}\mathbf{Z}}
where \eqn{\mathbf{Z}\in \mathcal{N}\left( 0,\mathbf{I}_{d}\right)},
\eqn{ V \geq 0}, is independent of \eqn{\mathbf{Z}}, is a non-negative,
scalar-valued variate, which is \emph{Generalized Inverse Gaussian} (scalar
 valued GIG), \eqn{V\in GIG\left( \lambda ,\chi ,\psi \right)}.
}
\examples{
lambda <- 1
chi <- 2
psi <- 2
mu <- rep(0,2)
sigma <- diag(2)
gamma <-  c(0.2,0.5)
MomCumGenHyp(r=4,lambda, chi, psi, mu, sigma, gamma)
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
