#' Calculate N Harvest Index (NHI)
#' @description
#' The percent of plant tissue N that is contained in the yield component.
#' Formula: NHI = YieldF / PlantNf
#' @param YieldF A numeric vector of final yield values.
#' @param PlantNf A numeric vector for total plant tissue N.
#' @return A numeric vector of NHI values.
#' @examples
#' YieldF <- c(10, 12, 15)
#' PlantNf <- c(2.5, 3.0, 3.2)
#' NHI(YieldF, PlantNf)
#' @export
NHI <- function(YieldF, PlantNf) {
  return(YieldF / PlantNf)
}