% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRE.R
\name{NRE}
\alias{NRE}
\title{Calculate Fertilizer N Recovery Efficiency (NRE)}
\usage{
NRE(PlantNf, PlantN0, FertN)
}
\arguments{
\item{PlantNf}{A numeric vector of plant N in fertilized conditions.}

\item{PlantN0}{A numeric vector of plant N in control conditions.}

\item{FertN}{A numeric value or vector for fertilizer N input.}
}
\value{
A numeric vector of NRE percentages.
}
\description{
The percentage of fertilizer N that is taken up by the plant.
Formula: NRE = ((PlantNf - PlantN0) / FertN) * 100
}
\examples{
PlantNf <- c(3.5, 4.0, 4.2)
PlantN0 <- c(2.0, 2.0, 2.0)
FertN <- 50
NRE(PlantNf, PlantN0, FertN)
}
