% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRE15.R
\name{NRE15}
\alias{NRE15}
\title{Calculate Isotope-Based Recovery Efficiency (NRE15)}
\usage{
NRE15(TNdfF, FertN)
}
\arguments{
\item{TNdfF}{Total N derived from Fertilizer (vector).}

\item{FertN}{Fertilizer N input (numeric vector or single value).}
}
\value{
A numeric vector of NRE15 percentages.
}
\description{
The percent recovery of fertilizer-N in plant and/or soil components.
Formula: NRE15 = (TNdfF / FertN) * 100
}
\examples{
TNdfF <- c(5.5, 6.0, 4.8)
FertN <- 50
NRE15(TNdfF, FertN)
}
