% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCGenExp.r
\name{HCGenExp}
\alias{HCGenExp}
\alias{dhc.gen.exp}
\alias{phc.gen.exp}
\alias{qhc.gen.exp}
\alias{rhc.gen.exp}
\alias{hhc.gen.exp}
\title{Half-Cauchy Generalized Exponential(HCGE) Distribution}
\usage{
dhc.gen.exp(x, alpha, lambda, theta, log = FALSE)
phc.gen.exp(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qhc.gen.exp(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rhc.gen.exp(n, alpha, lambda, theta)
hhc.gen.exp(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dhc.gen.exp}: numeric vector of (log-)densities
  \item \code{phc.gen.exp}: numeric vector of probabilities
  \item \code{qhc.gen.exp}: numeric vector of quantiles
  \item \code{rhc.gen.exp}: numeric vector of random variates
  \item \code{hhc.gen.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Cauchy Generalized Exponential(HCGE) distribution.
}
\details{
The HCGE distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The HCGE distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad 1 - \frac{2}{\pi }\arctan \left[ { - \frac{\alpha }{\theta }\ln 
\left( {1 - {e^{ - \lambda x}}} \right)} \right] \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dhc.gen.exp()} — Density function
  \item \code{phc.gen.exp()} — Distribution function
  \item \code{qhc.gen.exp()} — Quantile function
  \item \code{rhc.gen.exp()} — Random generation
  \item \code{hhc.gen.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dhc.gen.exp(x, 2.0, 0.5, 0.1)
phc.gen.exp(x, 2.0, 0.5, 0.1)
qhc.gen.exp(0.5, 2.0, 0.5, 0.1)
rhc.gen.exp(10, 2.0, 0.5, 0.1)
hhc.gen.exp(x, 2.0, 0.5, 0.1)

# Data
x <- conductors
# ML estimates
params = list(alpha=6.6141, lambda=0.9352, theta=0.0103)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = phc.gen.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qhc.gen.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
res <- gofic(x, params = params,
             dfun = dhc.gen.exp, pfun=phc.gen.exp, plot=FALSE)
print.gofic(res)

}
\references{
Chaudhary, A.K., Sapkota, L.P. &  Kumar, V. (2022). 
Half-Cauchy Generalized Exponential Distribution:Theory and Application. 
\emph{Journal of Nepal Mathematical Society (JNMS)}, \bold{5(2)}, 1--10.  
\doi{10.3126/jnms.v5i2.50018}

Gupta, R. D.,  & Kundu, D. (1999). 
Generalized exponential distributions. 
\emph{Australian and New Zealand Journal of Statistics}, \bold{41(2)}, 173--188.
}
