% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvPowerCauchy.r
\name{InvPowerCauchy}
\alias{InvPowerCauchy}
\alias{dinv.pow.cauchy}
\alias{pinv.pow.cauchy}
\alias{qinv.pow.cauchy}
\alias{rinv.pow.cauchy}
\alias{hinv.pow.cauchy}
\title{Inverse Power Cauchy Distribution}
\usage{
dinv.pow.cauchy(x, alpha, lambda, log = FALSE)
pinv.pow.cauchy(q, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
qinv.pow.cauchy(p, alpha, lambda, lower.tail = TRUE, log.p = FALSE)
rinv.pow.cauchy(n, alpha, lambda)
hinv.pow.cauchy(x, alpha, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dinv.pow.cauchy}: numeric vector of (log-)densities
  \item \code{pinv.pow.cauchy}: numeric vector of probabilities
  \item \code{qinv.pow.cauchy}: numeric vector of quantiles
  \item \code{rinv.pow.cauchy}: numeric vector of random variates
  \item \code{hinv.pow.cauchy}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Inverse Power Cauchy distribution.
}
\details{
The Inverse Power Cauchy distribution is parameterized by the parameters
\eqn{\alpha > 0} and \eqn{\lambda > 0}.


The Inverse Power Cauchy distribution has CDF:

\deqn{
F(x; \alpha, \lambda) =
\quad 1-2 \pi^{-1} \tan ^{-1}\left[\left(\frac{\lambda}{x}\right)
^\alpha\right]   \, ; \quad x > 0.
}

where \eqn{\alpha} and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dinv.pow.cauchy()} — Density function
  \item \code{pinv.pow.cauchy()} — Distribution function
  \item \code{qinv.pow.cauchy()} — Quantile function
  \item \code{rinv.pow.cauchy()} — Random generation
  \item \code{hinv.pow.cauchy()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dinv.pow.cauchy(x, 2.0, 5.0)
pinv.pow.cauchy(x, 2.0, 5.0)
qinv.pow.cauchy(0.5, 2.0, 5.0)
rinv.pow.cauchy(10, 2.0, 5.0)
hinv.pow.cauchy(x, 2.0, 5.0)

# Data
x <- headneck44
# ML estimates
params = list(alpha=1.4271, lambda=123.5294)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pinv.pow.cauchy, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qinv.pow.cauchy, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
res <- gofic(x, params = params,
             dfun = dinv.pow.cauchy, pfun=pinv.pow.cauchy, plot=FALSE)
print.gofic(res)

}
\references{
Sapkota L. P., & Kumar V. (2023). 
Applications and Some Characteristics of Inverse Power Cauchy Distribution. 
\emph{Reliability: Theory & Applications}. \bold{18, 1(72)}, 301--315. 
\doi{10.24412/1932-2321-2023-172-301-315}  
 
Chaudhary, A.K., Sapkota, L.P., & Kumar, V. (2020). 
Truncated Cauchy Power–Inverse Exponential distribution: Theory and Applications. 
\emph{IOSR Journal of Mathematics (IOSR-JM)}, \bold{16(4)}, Ser.IV, 12--23.
}
