% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyInvWeibull.r
\name{LindleyInvWeibull}
\alias{LindleyInvWeibull}
\alias{dlindley.inv.weib}
\alias{plindley.inv.weib}
\alias{qlindley.inv.weib}
\alias{rlindley.inv.weib}
\alias{hlindley.inv.weib}
\title{Lindley-Inverse Weibull Distribution}
\usage{
dlindley.inv.weib(x, alpha, beta, theta, log = FALSE)
plindley.inv.weib(q, alpha, beta, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.inv.weib(p, alpha, beta, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.inv.weib(n, alpha, beta, theta)
hlindley.inv.weib(x, alpha, beta, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.inv.weib}: numeric vector of (log-)densities
  \item \code{plindley.inv.weib}: numeric vector of probabilities
  \item \code{qlindley.inv.weib}: numeric vector of quantiles
  \item \code{rlindley.inv.weib}: numeric vector of random variates
  \item \code{hlindley.inv.weib}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley-Inverse Weibull distribution.
}
\details{
The Lindley-Inverse Weibull distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\theta > 0}.


The Lindley-Inverse Weibull distribution has CDF:

\deqn{
F(x; \alpha, \beta, \theta) =
\quad 1 - {\left( {1 - {e^{ - \alpha {x^{ - \beta }}}}} \right)^\theta }
\left\{ {1 - \left( {\frac{\theta }{{\theta  + 1}}} \right)\ln 
\left( {1 - {e^{ - \alpha {x^{ - \beta }}}}} \right)} \right\}  \, ; \quad x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\theta} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dlindley.inv.weib()} — Density function
  \item \code{plindley.inv.weib()} — Distribution function
  \item \code{qlindley.inv.weib()} — Quantile function
  \item \code{rlindley.inv.weib()} — Random generation
  \item \code{hlindley.inv.weib()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dlindley.inv.weib(x, 1.5, 2.0, 0.5)
plindley.inv.weib(x, 1.5, 2.0, 0.5)
qlindley.inv.weib(0.5, 2.0, 5.0, 0.1)
rlindley.inv.weib(10, 1.5, 2.0, 0.5)
hlindley.inv.weib(x, 1.5, 2.0, 0.5)

# Data
x <- waiting
# ML estimates
params = list(alpha=9.3340, beta=0.3010, theta=104.4248)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.inv.weib, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.inv.weib, fit.line=FALSE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.inv.weib, pfun=plindley.inv.weib, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2020). 
Lindley inverse Weibull distribution: Theory and Applications.
\emph{Bull. Math. & Stat. Res.}, \bold{8(3)}, 32--46.
}
