\name{rainfall}
\alias{rainfall}
\title{March Rainfall in Minneapolis/St. Paul}

\description{
A dataset of thirty consecutive March precipitation values (in inches) recorded
in Minneapolis/St. Paul. These data were originally presented by Hinkley (1977)
in the context of power transformations and applied statistical analysis.
}

\usage{
rainfall
}

\format{
A numeric vector of length 30 containing March rainfall amounts in inches.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 30 observed precipitation amounts (in inches) recorded
for the month of March in Minneapolis/St. Paul over consecutive years. Each
value represents the total March rainfall for a single year. The dataset is
commonly used to illustrate power transformations, regression diagnostics, and
exploratory data analysis techniques in applied statistics.
}

\details{
Hinkley (1977) used this dataset to illustrate methods for selecting power
transformations in statistical modeling. The dataset is frequently cited in
regression diagnostics and transformation literature.
}

\references{
Hinkley, D. (1977). On quick choice of power transformations.
\emph{Journal of the Royal Statistical Society, Series C (Applied Statistics)},
26, 67--69.
}

\examples{
summary(rainfall)

hist(
  rainfall,
  main = "March Rainfall Histogram",
  xlab = "Rainfall (inches)"
)

plot(
  rainfall,
  type = "o",
  main = "March Rainfall Series",
  ylab = "Inches",
  xlab = "Observation"
)
}

\keyword{datasets}
