% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.Subcascades}
\alias{summary.Subcascades}
\title{Summary Subcascades Characteristics}
\usage{
\method{summary}{Subcascades}(object = NULL, includeClassSummary = TRUE, digits = 3, ...)
}
\arguments{
\item{object}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.}

\item{includeClassSummary}{Boolean indicating if the occurrence of classes by size should be included in the summary.}

\item{digits}{Integer defining the number of decimal places as it is used in the \code{round}-function.}

\item{...}{Further arguments passed from other methods.}
}
\description{
Generates a general overview of the characteristics of the Subcascades object.
}
\details{
This function gives a general overview of characteristics of the Subcascades object, like number of cascades or maximal cascade length.
}
\examples{
library(TunePareto)
data(esl)
data <- esl$data
labels <- esl$labels
foldList <- generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap <- predictionMap(data, labels, foldList = foldList, 
                        classifier = tunePareto.svm(), kernel='linear')
# generate Subcascades object
subc <- subcascades(predMap,thresh=0.7,numSol=10000)

summary(subc)
}
\seealso{
\code{\link{subcascades}}, \code{\link{summary.PredictionMap}}, \code{\link{summary.Groupwise}}, \code{\link{summary.Conf}}, \code{\link{summary.ConfusionTable}}
}
