test_that("returns empty numeric vector when no roots", {
  f <- function(x) x^2 + 1
  r <- encontrar_raices(f, interval = c(-2, 2), n_subintervals = 20)
  expect_type(r, "double")
  expect_length(r, 0)
})

test_that("removes duplicate roots arising from adjacent subintervals", {
  # Many subintervals around root 0, could be found multiple times
  f <- function(x) x
  r <- encontrar_raices(f, interval = c(-1, 1), n_subintervals = 200)
  expect_length(r, 1)
  expect_equal(r, 0, tolerance = 1e-8)
})

test_that("skips subintervals with non-finite function values without error", {
  f <- function(x) ifelse(x == 0, NaN, 1 / x)  # non-finite at 0, no sign change root logic should skip
  expect_silent({
    r <- encontrar_raices(f, interval = c(-1, 1), n_subintervals = 50)
  })
  expect_type(r, "double")
})
