% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{find_interfering_v_from_B_sets}
\alias{find_interfering_v_from_B_sets}
\title{Find all interfering v-structures for a given collection of B-sets}
\usage{
find_interfering_v_from_B_sets(B_sets)
}
\arguments{
\item{B_sets}{a boolean matrix with \code{(2 + length(children))}
columns and \code{length(parents)} rows.
They are assumed to be sorted in increasing order of row sums,
i.e. by increasing order of set cardinality.
Typically, this will be the output of \code{find_B_sets_v}
for some node \code{v}.}
}
\value{
\code{NULL} if there is no interfering v-structures.
Else, it returns a \code{data.frame} with 4 columns \itemize{
  \item \code{A}: a list of children of \code{v}
  \item \code{B}: a list of children of \code{v}, disjoint from \code{A}
  \item \code{parents.A.but.not.parents.B}: a list of common parents of
  nodes of \code{A}, that are not parents of nodes of \code{B}
  \item \code{parents.B.but.not.parents.A}: a list of common parents of
  nodes of \code{B}, that are not parents of nodes of \code{A}
}
Each line correspond to 1 interfering v-structure.
}
\description{
Find all interfering v-structures for a given collection of B-sets
}
\examples{
DAG = create_empty_DAG(7)
DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
DAG = bnlearn::set.arc(DAG, 'U4', 'U5')

DAG = bnlearn::set.arc(DAG, 'U1', 'U6')
DAG = bnlearn::set.arc(DAG, 'U5', 'U6')
DAG = bnlearn::set.arc(DAG, 'U2', 'U7')
DAG = bnlearn::set.arc(DAG, 'U5', 'U7')

B_sets = find_B_sets_v(DAG, v = 'U5')
find_interfering_v_from_B_sets(B_sets)

# Adding the missing arc
DAG = bnlearn::set.arc(DAG, 'U1', 'U7')
# Now no interfering v-structure
B_sets = find_B_sets_v(DAG, v = 'U5')
find_interfering_v_from_B_sets(B_sets)

}
