% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_classes.R
\docType{class}
\name{estimate.mpin-class}
\alias{estimate.mpin-class}
\alias{show,estimate.mpin-method}
\title{MPIN estimation results}
\usage{
\S4method{show}{estimate.mpin}(object)
}
\arguments{
\item{object}{an object of class \code{estimate.mpin}}
}
\description{
The class \code{estimate.mpin} is the blueprint of \code{S4} objects
that store the results of the estimation of the \code{MPIN} model, using the
function \code{mpin_ml()}.
}
\section{Slots}{

\describe{
\item{\code{success}}{(\code{logical}) returns the value \code{TRUE} when the
estimation has succeeded, \code{FALSE} otherwise.}

\item{\code{errorMessage}}{(\code{character}) returns an error message if the estimation
of the \code{MPIN} model has failed, and is empty otherwise.}

\item{\code{convergent.sets}}{(\code{numeric}) returns the number of initial parameter
sets at which the likelihood maximization converged.}

\item{\code{method}}{(\code{character}) returns the method of estimation used, and is
equal to 'Maximum Likelihood Estimation'.}

\item{\code{layers}}{(\code{numeric}) returns the number of layers detected in the trading
data, or provided by the user.}

\item{\code{detection}}{(logical) returns a reference to the layer-detection
algorithm used (\code{"E"}, \code{"EG"}, \code{"ECM"}), if any algorithm is used. If the
number of layers is provided by the user, detection takes the value \code{"USER"}.}

\item{\code{parameters}}{(\code{list}) returns the list of the maximum likelihood
estimates (\eqn{\alpha}, \eqn{\delta}, \eqn{\mu}, \eb, \es), where
\eqn{\alpha}, \eqn{\delta}, and \eqn{\mu} are numeric vectors of length
\code{layers}.}

\item{\code{aggregates}}{(\code{numeric}) returns an aggregation of information layers'
estimated parameters alongside with \eb, and \es. The aggregated parameters
are calculated as follows:
\eqn{\alpha_{agg} = \sum \alpha_j}{}\if{html}{\eqn{\alpha*= \sum
\alpha}\subit{j}}
\eqn{\delta_{agg} = \sum \alpha_j \times \delta_j}{}\if{html}{\eqn{\delta*=
\sum \alpha}\subit{j}\eqn{\delta}\subit{j}},
and \eqn{\mu_{agg} = \sum \alpha_j \times \mu_j}{}\if{html}{\eqn{\mu*= \sum
\alpha}\subit{j}\eqn{\mu}\subit{j}}.}

\item{\code{likelihood}}{(\code{numeric}) returns the value of the (log-)likelihood
function evaluated at the optimal set of parameters.}

\item{\code{mpinJ}}{(\code{numeric}) returns the values of the multilayer probability of
informed trading per layer, calculated using the layer-specific estimated
parameters.}

\item{\code{mpin}}{(\code{numeric}) returns the global value of the multilayer probability
of informed trading. It is the sum of the multilayer probabilities of
informed trading per layer stored in the slot \code{mpinJ}.}

\item{\code{mpin.goodbad}}{(\code{list}) returns a list containing a decomposition of
\code{MPIN} into good-news, and bad-news \code{MPIN} components. The decomposition
has been suggested for PIN measure in
\insertCite{Brennan2016;textual}{PINstimation}. The list has four elements:
\code{mpinG}, and \code{mpinB} are the global good-news, and bad-news components of
\code{MPIN}, while \code{mpinGj}, and \code{mpinBj} are two vectors containing  the
good-news (bad-news) components of \code{MPIN} computed per layer.}

\item{\code{dataset}}{(\code{dataframe}) returns the dataset of buys and sells used
in the maximum likelihood estimation of the MPIN model.}

\item{\code{initialsets}}{(\code{dataframe}) returns the initial parameter sets used
in the maximum likelihood estimation of the MPIN model.}

\item{\code{details}}{(\code{dataframe}) returns a dataframe containing the estimated
parameters of the \code{MLE} method for each initial parameter set.}

\item{\code{runningtime}}{(\code{numeric}) returns the running time of the estimation of
the \code{MPIN} model in seconds.}
}}

